/// @description Update the enemy

if (oGameController.state != gameState.paused and
	oGameController.state != gameState.waiting) {

	if (life <= 0) instance_destroy();

	// Attack cooldown should cool down independent of state
	if (attackCooldown > 0) attackCooldown -= 1;

	// Clamp moving speed
	switch(state) {
		case enemyState.idle:
			if		(xSpeed >  maxMoveSpeed) xSpeed =  maxMoveSpeed;
			else if (xSpeed < -maxMoveSpeed) xSpeed = -maxMoveSpeed;
			break;
		case enemyState.follow:
			if		(xSpeed >  maxRunSpeed) xSpeed =  maxRunSpeed;
			else if (xSpeed < -maxRunSpeed) xSpeed = -maxRunSpeed;
			break;
	}

	// Horizontal movement and collision checking
	if (!place_meeting(x + xSpeed, y, oCollision)) {
		x += xSpeed;
	} else {
		Log("moving near collision " + string(xSpeed));
		var xSpeedSign = sign(xSpeed);
		while (!place_meeting(x + xSpeedSign, y, oCollision)) {
			x += xSpeedSign;
		}
		xSpeed = 0;
		EnemyChangeDirection();
	}

	// Enemy State Machine
	switch(vertState) {
		case verticalState.falling:
			EnemyStateFalling();
			break;
		case verticalState.onGround:
			EnemyStateOnGround();
			break;
		default:
			EnemyStateFalling();
	}
	switch(state) {
		case enemyState.idle:
			EnemyStateIdle();
			break;
		case enemyState.follow:
			EnemyStateFollow();
			break;
		case enemyState.stunned:
			EnemyStateStunned();
			break;
		case enemyState.attack:
			EnemyStateAttack();
			break;
	}

	// Vertical movement with collision checks
	if (vertState != verticalState.onGround) {
		if (ySpeed < maxFallSpeed)
			ySpeed += weight;
	}

	// Warp
	WarpHorizontaly();

	// Animation and graphics
	if (!place_meeting(x, y + ySpeed, oCollision)) {
		y += ySpeed;
	} else {
		move_contact_solid(point_direction(x, y, x, y + ySpeed), maxFallSpeed);
		ySpeed = 0;
	}
}